const express = require('express');
const app = express();
const path = require('path');
const bodyParser = require('body-parser');
const https = require('https');
const fs = require('fs');
const forms = require('./src/routes/registroCliente');
const servicesClientes = require('./src/routes/guardarDatos');
const servicesDir = require('./src/routes/direcciones');



app.set('view engine', "ejs");
app.set('views', path.join(__dirname, "src", "views"));
app.use(express.static(path.join(__dirname, "src", "public")));

app.use(
    bodyParser.urlencoded({
        extended: true,
        parameterLimit: 10000,
        limit: 1024 * 1024 * 10
    })
);

app.use(bodyParser.json({limit: "50mb"}));

app.use(express.json());

const PORT = 3502
app.use('/', forms);
app.use('/servicios-clientes', servicesClientes);
app.use('/servicios-dir', servicesDir);

app.listen(PORT, ()=>{
    console.log('INICIADO');
});

/*https.createServer({
    key: fs.readFileSync('/home/dattdev/ssl/keys/c8054_c534b_6bfeaeffac0a54e932a278b9665dc1e3.key'),
    cert: fs.readFileSync('/home/dattdev/ssl/certs/tpv_dattdev_app_c8054_c534b_1697846399_9adc8a43e96d49be88f85d8d020d88cf.crt')
  }, app).listen(PORT, function(){
    console.log("My HTTPS server listening on port " + PORT + "...");
});*/