const nuevoCliente = require('../../services/servicesNuevocliente');
const path = require('path');
const fs = require('fs');
const multer = require('multer')


exports.guardarCliente = async(req, res)=>{
    
    var reponse = await nuevoCliente.nuevoCliente(req.body);

    res.status(reponse.code).json({id: reponse.id});
}

exports.guardarArchivos = async(req, res)=>{
    try {
        var { idCliente } = req.params;
        const destino = path.join(__dirname, '../../public', `cliente_${String(idCliente)}`);

  if (!fs.existsSync(destino)) {
    fs.mkdirSync(destino, { recursive: true });
  }

  const storage = multer.diskStorage({
    destination: (req, file, cb) => cb(null, destino),
    filename: (req, file, cb) => {
      const ext = path.extname(file.originalname);
      cb(null, file.fieldname + '-' + Date.now() + ext);
    }
  });

  const upload = multer({ storage }).fields([
    { name: 'contrato', maxCount: 1 },
    { name: 'identificacion', maxCount: 1 }
  ]);

  upload(req, res, (err) => {
    if (err) {
      console.error('❌ Error al subir archivos:', err);
      return res.status(500).json({ error: 'Error al subir archivos' });
    }
    res.status(200).json({ mensaje: 'Archivos subidos correctamente' });
  });

    } catch (error) {
        console.log(error);
    }
}

exports.recuperarClientes = async(req, res)=>{
    var response = await nuevoCliente.obtenerClientes(req.params);
    
    res.status(response.code).json({status: response.status, clientes: response.clientes});
}

exports.editarCliente = async(req, res)=>{
  var reponse = await nuevoCliente.editarCliente(req.body);

    res.status(reponse.code).json({id: reponse.id});
}

exports.archivos = async(req, res)=>{
  console.log(req.params);
    var response = await nuevoCliente.obtenerArchivos(req.params);

    res.json(response);
}