const views = {};
const serviciosClientes = require('../../services/servicesNuevocliente');

views.formulario = (req, res)=>{
    try {
        
        res.render('formRegistro', {
            titulo: 'Registro de cliente',
            disponibilidad: [4579],
            usuario: req.params.usuario
        })
    } catch (error) {
        console.log(error);
    }
}

views.principal = (req, res)=>{
    try {
        res.render('index', {
            titulo: 'Inicio',
            usuario: req.params.usuario
        });
    } catch (error) {
        console.log(error);
    }
}

views.listadoClientes = (req, res)=>{
    try {
        res.render('listadoClientes', {
            titulo: 'Listado de clientes',
            usuario: req.params.usuario
        });
    } catch (error) {
        console.log(error);
    }
}

views.editarCliente = async(req, res)=>{
    try {
        var info = await serviciosClientes.obterRegistro(req.params.id);
        res.render('editarCliente', {
            titulo: 'Editar',
            data: info[0],
            usuario: req.params.usuario
        });
    } catch (error) {
        console.log(error);
    }
}

views.archivosClientes = async(req, res)=>{
    try {
        res.render('listadoArchivos', {
            titulo: 'archivos',
            usuario: req.params.usuario,
            cliente: req.params.cliente
        })
    } catch (error) {
        console.log(error);
    }
}


module.exports = views