const pool = require('../db/db');
const path = require('path');
const fs = require('fs').promises;

function obtenerFechaActual() {
  const ahora = new Date();

  const anio = ahora.getFullYear();
  const mes = String(ahora.getMonth() + 1).padStart(2, '0');
  const dia = String(ahora.getDate()).padStart(2, '0');

  const horas = String(ahora.getHours()).padStart(2, '0');
  const minutos = String(ahora.getMinutes()).padStart(2, '0');
  const segundos = String(ahora.getSeconds()).padStart(2, '0');

  return `${anio}-${mes}-${dia} ${horas}:${minutos}:${segundos}`;
}

async function eliminarArchivosDeCarpeta(carpeta) {
  try {
    const archivos = await fs.readdir(carpeta);

    for (const archivo of archivos) {
      const rutaCompleta = path.join(carpeta, archivo);
      const stat = await fs.stat(rutaCompleta);

      if (stat.isFile()) {
        await fs.unlink(rutaCompleta);
        console.log('🗑️ Archivo eliminado:', rutaCompleta);
      }
    }

    console.log('✅ Todos los archivos han sido eliminados.');
  } catch (err) {
    console.error('❌ Error al eliminar archivos:', err);
  }
}



exports.nuevoCliente = async(datos)=>{
    try {
        
        var {nombre, email, telefono, direccion, zip, pais, estado, ciudad, userId} = datos;
        var [nuevoCliente] = await pool.query('INSERT INTO cat_registros SET ?', {
            db_nombre: nombre,
            db_telefono: telefono,
            db_direccion: direccion,
            db_zip: zip,
            db_correo: email,
            db_pais: pais,
            db_estado: estado,
            db_ciudad: ciudad,
            db_usuario: userId,
            db_fecha: obtenerFechaActual()
        });

        return {
            code: 200,
            mensaje: 'Cliente guardado',
            id: nuevoCliente.insertId
        }
    } catch (error) {

        console.log(error);

        return {
            code: 400,
            mensaje: 'error al guardar'
        }
    }
}

exports.editarCliente = async(datos)=>{
    try {
        var {nombre, email, telefono, direccion, zip, pais, estado, ciudad, userId, idRegistro} = datos;

        await pool.query('UPDATE cat_registros SET ? WHERE id = ?', [{
            db_nombre: nombre,
            db_telefono: telefono,
            db_direccion: direccion,
            db_zip: zip,
            db_correo: email,
            db_pais: pais,
            db_estado: estado,
            db_ciudad: ciudad
        }, idRegistro]);


        const carpetaCliente = path.join(__dirname, '../public', 'cliente_'+idRegistro);

        eliminarArchivosDeCarpeta(carpetaCliente);

        return {
            code: 200,
            id: idRegistro
        }
        
    } catch (error) {
        console.log(error);
    }
}

exports.obtenerClientes = async(datos)=>{
    try {
        var {usuario} = datos;
        var [clientes] = await pool.query('SELECT C.id, C.db_nombre AS Cliente, C.db_correo, C.db_telefono, CONCAT(C.db_direccion, ", ", C.db_zip) AS Direccion, P.db_nombre AS Pais, E.db_nombre AS Estado, Ci.db_nombre AS Ciudad, C.db_fecha FROM cat_registros AS C INNER JOIN tbl_datos_paises AS P ON C.db_pais = P.id INNER JOIN tbl_datos_estados AS E ON C.db_estado = E.id INNER JOIN tbl_datos_ciudad AS Ci ON C.db_ciudad = Ci.id WHERE C.db_usuario = ?', [usuario]);
        return {
            code: 200,
            status: 'Clientes encontrados',
            clientes: clientes
        }
    } catch (error) {
        return {
            code: 400,
            status: 'error',
            clientes: error.messagge
        }
    }
}


exports.obterRegistro = async(id)=>{
    try {
        
        var [registro] = await pool.query('SELECT * FROM cat_registros WHERE id = ?', [id]);
        return registro;
    } catch (error) {
        console.log(error);
        return [];
    }
}

exports.obtenerArchivos = async(cliente)=>{
    try {
        const { idCliente } = cliente;

        const carpeta = path.join(__dirname, '../public', `cliente_${idCliente}`);

        const archivos = await fs.readdir(carpeta);

        const lista = archivos.map(nombre => ({
            nombre,
            ruta: `/cliente_${idCliente}/${nombre}`
        }));

        return lista

    } catch (error) {
        console.log(error);
        return [];
    }
}
